<?php
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
ini_set ("display_errors", "0");
error_reporting(E_ALL);
require("../connect.php");

// Check latest VKP
$stmtCheck = mysqli_prepare($conn, "SELECT FROM_UNIXTIME(field_875, '%Y-%m-%d') harvestdate 
FROM app_entity_61 WHERE FROM_UNIXTIME(field_875, '%Y-%m-%d') < DATE(NOW()) 
AND field_881 = ? ORDER BY id DESC LIMIT 1;");
mysqli_stmt_bind_param($stmtCheck, 'i', $_POST['empid']);
mysqli_stmt_execute($stmtCheck);
$resultCheck = mysqli_stmt_get_result($stmtCheck);

if (mysqli_num_rows($resultCheck) > 0) {

    $rowCheck = mysqli_fetch_assoc($resultCheck);

    // Get total janjang dan lokasi kerja
    $stmtJjgTotal = mysqli_prepare($conn, "SELECT SUM(field_1279) AS totaljjg, GROUP_CONCAT(DISTINCT field_872) AS loc
    FROM app_entity_61 WHERE field_881 = ? AND FROM_UNIXTIME(field_875, '%Y-%m-%d') = ?;");
    mysqli_stmt_bind_param($stmtJjgTotal, 'is', $_POST['empid'], $rowCheck['harvestdate']);
    mysqli_stmt_execute($stmtJjgTotal);
    $resultJjgTotal = mysqli_stmt_get_result($stmtJjgTotal);
    $rowJanjang = mysqli_fetch_assoc($resultJjgTotal);
    
    // Get detail upah harian, check in/out
    $stmtHarianUpah = mysqli_prepare($conn, "SELECT SUBSTRING_INDEX(field_4508, '<br>', 1) upahatt, 
    SUBSTRING_INDEX(SUBSTRING_INDEX(field_4508,'<br>',2),'<br>',-1) panendinas, 
    SUBSTRING_INDEX(SUBSTRING_INDEX(field_4508,'<br>',3),'<br>',-1) brd, 
    SUBSTRING_INDEX(SUBSTRING_INDEX(field_4508,'<br>',4),'<br>',-1) lngsr, 
    SUBSTRING_INDEX(SUBSTRING_INDEX(field_4508,'<br>',5),'<br>',-1) muat, 
    SUBSTRING_INDEX(SUBSTRING_INDEX(field_4508,'<br>',6),'<br>',-1) rawat, 
    SUBSTRING_INDEX(SUBSTRING_INDEX(field_4508,'<br>',7),'<br>',-1) umum, 
    SUBSTRING_INDEX(SUBSTRING_INDEX(field_4508,'<br>',8),'<br>',-1) tetap, 
    CONCAT('Rp',FORMAT(field_4495, 0),',-') AS hkupah, 
    CONCAT('Rp',FORMAT(field_4509, 0),',-') AS bersihdinas, 
    CONCAT('Rp',FORMAT(field_4511, 0),',-') AS natura, 
    CONCAT('Rp',FORMAT(field_4567, 0),',-') AS penalti, 
    (SELECT `name` FROM app_global_lists_choices WHERE id = field_4504) AS attcode, 
    (SELECT SUBSTRING(SEC_TO_TIME(field_1586), 4) FROM app_entity_81 WHERE field_1579 = field_4498 AND field_1570 = field_4497) cekin, 
    (SELECT SUBSTRING(SEC_TO_TIME(field_1587), 4) FROM app_entity_81 WHERE field_1579 = field_4498 AND field_1570 = field_4497) cekout 
    FROM app_entity_152 WHERE parent_item_id = ? AND FROM_UNIXTIME(field_4497, '%Y-%m-%d') = ?;");
    mysqli_stmt_bind_param($stmtHarianUpah, 'is', $_POST['empid'], $rowCheck['harvestdate']);
    mysqli_stmt_execute($stmtHarianUpah);
    $resultHarianUpah = mysqli_stmt_get_result($stmtHarianUpah);
    $rowUpah = mysqli_fetch_assoc($resultHarianUpah);
    
    echo json_encode(array_map('utf8_encode', array(
        "TANGGAL" => $rowCheck['harvestdate'], 
        "TOTALJJG" => $rowJanjang['totaljjg'], 
        "LOKASI" => $rowJanjang['loc'],
        "ATTCODE" => $rowUpah['attcode'],
        "UPAHBRIEFING" => $rowUpah['upahatt'],
        "UPAHPANENDINAS" => $rowUpah['panendinas'],
        "UPAHBRONDOLAN" => $rowUpah['brd'],
        "UPAHLANGSIR" => $rowUpah['lngsr'],
        "UPAHMUAT" => $rowUpah['muat'],
        "UPAHRAWAT" => $rowUpah['rawat'],
        "UPAHUMUM" => $rowUpah['umum'],
        "UPAHTETAP" => $rowUpah['tetap'],
        "PENALTI" => $rowUpah['penalti'],
        "HKUPAH" => $rowUpah['hkupah'],
        "BERSIHDINAS" => $rowUpah['bersihdinas'],
        "NATURA" => $rowUpah['natura'],
        "CHECKIN" => $rowUpah['cekin'], 
        "CHECKOUT" => $rowUpah['cekout']
    )));
}



?>